using System;
using System.Collections.Generic;
using System.Linq;

public class Tacka
{
    public long X { get; set; }
    public long Y { get; set; }
}

public class Resenje
{
    // Funkcija za prebrojavanje parova (A, B) gde je vA > vB (inverzije)
    // Korišcenjem Merge Sort algoritma (O(N log N))
    private static long PrebrojInverzije(List<long> lista)
    {
        if (lista.Count <= 1)
        {
            return 0;
        }

        long count = 0;
        int middle = lista.Count / 2;
        List<long> left = lista.GetRange(0, middle);
        List<long> right = lista.GetRange(middle, lista.Count - middle);

        count += PrebrojInverzije(left);
        count += PrebrojInverzije(right);

        // Spajanje (Merge) i brojanje inverzija
        int i = 0, j = 0, k = 0;
        while (i < left.Count && j < right.Count)
        {
            if (left[i] <= right[j])
            {
                lista[k++] = left[i++];
            }
            else
            {
                // Inverzija: svi preostali elementi u 'left' (left.Count - i)
                // su veci od trenutnog right[j]
                count += (left.Count - i);
                lista[k++] = right[j++];
            }
        }

        while (i < left.Count)
        {
            lista[k++] = left[i++];
        }

        while (j < right.Count)
        {
            lista[k++] = right[j++];
        }

        return count;
    }

    // Funkcija za prebrojavanje parova (A, B) gde je uB > uA (neinverzije)
    // Za grupu tacaka sa istim v. Ukupan broj parova je $\binom{m}{2}$.
    private static long PrebrojNeinverzije(List<long> lista)
    {
        int m = lista.Count;
        if (m < 2) return 0;
        // Formula za kombinacije n nad k: n * (n-1) / 2
        return (long)m * (m - 1) / 2;
    }

    // Funkcija za prebrojavanje ortogonalnih susreta
    // Susret se dešava ako je razlika koordinata parna.
    private static long PrebrojOrtogonalneSusrete(List<long> lista)
    {
        if (lista.Count <= 1)
        {
            return 0;
        }

        // Delimo na parne i neparne (zbog parnosti razlike koordinata)
        long countPar = 0;
        long countNepar = 0;

        foreach (var val in lista)
        {
            if (val % 2 == 0)
            {
                countPar++;
            }
            else
            {
                countNepar++;
            }
        }

        // Susreti unutar parnih: $\binom{k_{par}}{2}$
        long susretiPar = countPar * (countPar - 1) / 2;
        
        // Susreti unutar neparnih: $\binom{k_{nepar}}{2}$
        long susretiNepar = countNepar * (countNepar - 1) / 2;

        return susretiPar + susretiNepar;
    }

    public static void Main(string[] args)
    {
        // Brzo ucitavanje N
        if (!int.TryParse(Console.ReadLine(), out int N) || N < 2)
        {
            return;
        }

        Tacka[] tacke = new Tacka[N];

        for (int i = 0; i < N; i++)
        {
            string line = Console.ReadLine();
            if (string.IsNullOrEmpty(line)) continue;
            string[] parts = line.Split(' ');
            
            if (parts.Length == 2 && 
                long.TryParse(parts[0], out long x) && 
                long.TryParse(parts[1], out long y))
            {
                tacke[i] = new Tacka { X = x, Y = y };
            }
            else
            {
                // Handle potential malformed input gracefully if needed
            }
        }

        long ukupanBrojPozdrava = 0;

        // --- I. Dijagonalni susreti (Slucaj 1: Transformacija koordinata u u=x+y, v=x-y) ---

        // A) uA = uB i vB < vA (Sever-Zapad i Jug-Istok)
        // Grupisemo po u, brojimo inverzije v
        Dictionary<long, List<long>> grupePoU = new Dictionary<long, List<long>>();
        foreach (var t in tacke)
        {
            long u = t.X + t.Y;
            long v = t.X - t.Y;
            if (!grupePoU.ContainsKey(u))
            {
                grupePoU[u] = new List<long>();
            }
            grupePoU[u].Add(v);
        }

        foreach (var group in grupePoU.Values)
        {
            ukupanBrojPozdrava += PrebrojInverzije(group);
        }

        // B) vA = vB i uB > uA (Sever-Istok i Jug-Zapad)
        // Grupisemo po v, brojimo $\binom{m}{2}$ parova za u
        Dictionary<long, List<long>> grupePoV = new Dictionary<long, List<long>>();
        foreach (var t in tacke)
        {
            long u = t.X + t.Y;
            long v = t.X - t.Y;
            if (!grupePoV.ContainsKey(v))
            {
                grupePoV[v] = new List<long>();
            }
            grupePoV[v].Add(u);
        }

        foreach (var group in grupePoV.Values)
        {
            ukupanBrojPozdrava += PrebrojNeinverzije(group);
        }


        // --- II. Ortogonalni susreti (Slucaj 2: Susret na istoj X ili Y osi) ---

        // A) yA = yB i xB - xA = 2k (Sever-Jug)
        // Grupišemo po Y, proveravamo parnost X koordinata
        Dictionary<long, List<long>> grupePoY = new Dictionary<long, List<long>>();
        foreach (var t in tacke)
        {
            if (!grupePoY.ContainsKey(t.Y))
            {
                grupePoY[t.Y] = new List<long>();
            }
            grupePoY[t.Y].Add(t.X);
        }

        foreach (var group in grupePoY.Values)
        {
            ukupanBrojPozdrava += PrebrojOrtogonalneSusrete(group);
        }

        // B) xA = xB i yB - yA = 2k (Istok-Zapad)
        // Grupišemo po X, proveravamo parnost Y koordinata
        Dictionary<long, List<long>> grupePoX = new Dictionary<long, List<long>>();
        foreach (var t in tacke)
        {
            if (!grupePoX.ContainsKey(t.X))
            {
                grupePoX[t.X] = new List<long>();
            }
            grupePoX[t.X].Add(t.Y);
        }

        foreach (var group in grupePoX.Values)
        {
            ukupanBrojPozdrava += PrebrojOrtogonalneSusrete(group);
        }
        
        // --- Kraj ---
        Console.WriteLine(ukupanBrojPozdrava);
    }
}